#ifndef DCOMBOBOX_H
    #define DCOMBOBOX_H
    
    #include "DBaseControlWin.h"
    #include "DString.h"

    namespace DWL {
        class DComboBox : public DBaseControlWin { 
          public :
            ////////////////////////////////////// DObjeto
            DWL_DECLARAR_DOBJETO(TEXT("DComboBox"), DEnum_Objeto_ComboBox);
                                                //
                                                //! Destructor
                                                // ~DComboBox(void);
                                               ~DComboBox(void) { 
                                                    Destruir(); 
                                                };
									            //
									            //! Funcin para crear el control
									            //  HWND Crear(HWND hWndPadre, const TCHAR *Text, const int cX, const int cY, const int cAncho, const int cAltoListaCombo, const int cID, const DWORD Estilos)
          	HWND                                Crear(DBaseWnd *nPadre, const TCHAR *nTexto, const int cX, const int cY, const int cAncho, const int cAltoListaCombo, const UINT cID, const DWORD Estilos);
								    	        //
							    		        //! Funcin para asignar un EditBox ya creado en un Dialogo
						    			        //  void Asignar(HWND hWndPadre, const int ID_Control, const TCHAR *nTexto = NULL);
            HWND                                Asignar(DBaseWnd *nPadre, const UINT cID, const TCHAR *nTexto = NULL);
									            //
									            //! Funcin que asigna la altura de la lista desplegable del control
									            //  void AltoLista(const int nAlto);
		    void						        AltoLista(const int nAlto) {
										            SendMessage(_hWnd, CB_SETDROPPEDWIDTH , nAlto, 0);
									            };
									            //
									            //! Funcin para agregar un item en la posicion especificada
									            //  inline void AgregarItem(const TCHAR *Txt, const int Pos = -1);
		    inline void                         AgregarItem(const TCHAR *Txt, const int Pos = -1) {
										            SendMessage(_hWnd, CB_INSERTSTRING, Pos, (LPARAM)Txt);
									            };
									            //
									            //! Funcin para borrar el item de la posicion especificada
									            //  inline void BorrarItem(const int Pos);
		    inline void                         BorrarItem(const int Pos) {
										            SendMessage(_hWnd, CB_DELETESTRING, Pos, 0);
									            };
									            //
									            //! Funcin que borra todo el combobox
									            //  inline void BorrarTodo(void);
		    inline void                         BorrarTodo(void) {
										            SendMessage(_hWnd, CB_RESETCONTENT, 0, 0);
									            };
									            //
									            //! Numero total de strings en el combo
									            //  inline int TotalItems(void) ;
		    inline int                          TotalItems(void) const {
										            return static_cast<int>(SendMessage(_hWnd, CB_GETCOUNT, 0, 0));
									            };
									            //
									            //! Funcin que retorna el Item Seleccionado
									            //  inline int Seleccion(void)
		    inline int                          Seleccion(void) const {
										            return static_cast<int>(SendMessage(_hWnd, CB_GETCURSEL, 0, 0));
									            };
									            //
									            //! Funcin que asigna el Item Seleccionado
									            //  inline void Seleccion(const int Pos)
		    inline void                         Seleccion(const int Pos) {
										            SendMessage(_hWnd, CB_SETCURSEL, Pos, 0);
									            };
									            //
									            //! Funcin para asignar texto (solo valida si el ComboBox utiliza un editbox para mostrar la seleccion, si utiliza un static text debes utilizar las funciones SeleccionarTexto o Seleccion)
									            //  void AsignarTexto(const TCHAR *Txt);
		    void                                AsignarTexto(const TCHAR *Txt) {
										            SendMessage(_hWnd, WM_SETTEXT, 0, reinterpret_cast<LPARAM>(Txt));
									            };
                                                //
                                                //! Funcin que selecciona el texto de la lista mas parecido al especificado.
                                                //  void SeleccionarTexto(const TCHAR *Txt);
		    void                                SeleccionarTexto(const TCHAR *Txt) {
                                                    SendMessage(_hWnd, CB_SELECTSTRING, -1, (LPARAM)Txt);
									            };
									            //
									            //! Funcin que retorna el texto actual
									            //  void ObtenerTexto(DString &nTexto);
		    void						        ObtenerSeleccion(DString &nTexto) {
                                                    int Item = static_cast<int>(SendMessage(_hWnd, CB_GETCURSEL , 0, 0));                                        
                                                    int Tam = static_cast<int>(SendMessage(_hWnd, CB_GETLBTEXTLEN, Item, 0));
                                                    if (Tam > 0) {
									                    TCHAR *Tmp = new TCHAR[Tam + 1];
                                                        SendMessage(_hWnd, CB_GETLBTEXT, Item, (LPARAM)Tmp);
									                    nTexto = Tmp;
                                                        delete [] Tmp;
                                                    }
                                                    else {
                                                        nTexto.Borrar();
                                                    }
                                                };
									            //
									            //! Funcin que retorna el texto actual
									            //  void ObtenerTexto(DString &nTexto);
		    void						        ObtenerTexto(DString &nTexto) {
                                                    TCHAR Tmp[512];
										            GetDlgItemText(GetParent(_hWnd), static_cast<int>(GetWindowLongPtr(_hWnd, GWL_ID)), Tmp, 512);
                                                    nTexto = Tmp;
									            };
                                                //
                                                //! Funcin para mostrar / ocultar la lista desplegable del ComboBox
                                                //  void MostrarLista(const bool nMostrar);
            void                                MostrarLista(const bool nMostrar) {
                                                    SendMessage(_hWnd, CB_SHOWDROPDOWN, static_cast<WPARAM>(nMostrar), 0);
                                                };
										        //
										        //! Funcin que retorna la fuente 
										        //  inline HFONT Fuente(void);
		    inline HFONT				        Fuente(void) {
											        return (HFONT)SendMessage(_hWnd, WM_GETFONT, 0, 0);
										        };
										        //
										        //! Funcin para asignar la fuente
										        //  inline void Fuente(HFONT nFuente);
		    inline void					        Fuente(HFONT nFuente) {
											        SendMessage(_hWnd, WM_SETFONT, (WPARAM)nFuente , 0);
										        };

									            //! Funcin para mostrar / ocultar el ComboBox.
									            /*! Esta funcin muestra / oculta el ComboBox.
											            \fn			virtual void Visible(const bool nMostrar);
											            \param[in]	nMostrar : True para mostrar la ventana / control, false para ocultarlo.
											            \return		No devuelve nada.
									            */
            inline void                         Visible(const bool nMostrar) {
                                                    SendMessage(_hWnd, CB_SHOWDROPDOWN, FALSE, 0);
                                                    DBaseWnd::Visible(nMostrar);
                                                };

                                                //! Funcin que devuelve que tipo de clase BaseWnd es esta clase
                                                /*! Esta funcin devuelve que tipo de clase BaseWnd es esta clase
                                                        \fn         virtual const DEnum_TipoBaseWnd TipoBaseWnd(void);
                                                        \returns    Devuelve un valor de DEnum_TipoBaseWnd
                                                        \remars     Esta funcin identifica que tipo de ventana o control se esta utilizando.
                                                */
            virtual const DEnum_TipoBaseWnd     TipoBaseWnd(void)   { return DEnum_TipoBaseWnd_ComboBox; };

									    //
									    //! Window procedure que reemplazara al WindowProcedure del ComboBox
									    //  LRESULT CALLBACK GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
//		    LRESULT CALLBACK            GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);

        };
    };
#endif


    // CBN_CLOSEUP          Al cerrar el ListBox (WM_COMMAND)                                                                               Evento_ComboBox_Lista_Ocultar
    // CBN_DBLCLK           Dobleclick en string del ListBox (WM_COMMAND)                                                                   Evento_ComboBox_Lista_DobleClick
    // CBN_DROPDOWN         Al mostrar el ListBox (WM_COMMAND)                                                                              Evento_ComboBox_Lista_Mostrar
    // CBN_EDITCHANGE       Al terminar de editar el EditBox (WM_COMMAND)                                                                   Evento_ComboBox_Edit_Cambiado
    // CBN_EDITUPDATE       Al empezar de editar el EditBox (WM_COMMAND)                                                                    Evento_ComboBox_Edit_Cambiando
    // CBN_ERRSPACE         Sin memoria.... (WM_COMMAND)                                                            NO AADIR
    // CBN_KILLFOCUS        Al perder el foco (WM_COMMAND)                                                                                  Evento_ComboBox_Foco_Perdido
    // CBN_SELCHANGE        Al cambiar la seleccion del ListBox (WM_COMMAND)                                                                Evento_ComboBox_CambioSeleccion
    // CBN_SELENDCANCEL     Al cambiar la seleccion y hacer click en otro control o cerrar el dialogo (WM_COMMAND)  NO LA VEO NECESARIA...  
    // CBN_SELENDOK         Al cambiar la seleccion y hacer click en el boton para cerrar la lista (WM_COMMAND)     NO LA VEO NECESARIA...
    // CBN_SETFOCUS         Al obtener el foco (WM_COMMAND)                                                                                 Evento_ComboBox_Foco_Obtenido



